<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * Classe che definisce i template delle cartelle di Geecom Doc, che possono essere caricati
    * quando viene creato un nuovo utente
    */

    class TemplateCartelle {
        private $db;
        private $id;
        private $cartellaCollegata;
        private $nome;
        private $descrizione;
        private $dataCreazione;
        
        function __construct($db, $id,$cartellaCollegata = 0,$nome = "", $descrizione = "", $dataCreazione = "") {
            $this->db = $db;
            $this->id = $id;
            $this->cartellaCollegata = $cartellaCollegata;
            $this->nome          = $nome;
            $this->descrizione      = $descrizione;
            $this->dataCreazione = $dataCreazione;
        }
        
        function crea() {
            $dataCreazione = date("Y-m-d");
            
            // creo la cartella collegata al template (deve essere messa come sottocartella della cartella Template che ha id = 2)
            $query = "INSERT INTO geecD_cartelle VALUES(NULL,'2','$this->nome','cartella collegata al tema $this->nome','$dataCreazione')";
            $idCartella = $this->db->eseguiQueryCreazione($query);
            
            // creo l'occorrenza nella tabella template
            $queryCreazioneTemplate = "INSERT INTO geecD_templateCartelle VALUES(NULL,'$idCartella','$this->nome','$this->descrizione','$dataCreazione')";
            $this->id = $this->db->eseguiQueryCreazione($queryCreazioneTemplate);
            return $this->id;
        }

        function modifica() {
            $query = "UPDATE geecD_templateCartelle SET cartellaCollegata='$this->cartellaCollegata', nome='$this->nome', descrizione = '$this->descrizione' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecD_templateCartelle",$this->id);
        }
         
        function caricaDatiDalDatabase() {
            $datiTemplate = $this->db->leggiSingolaRiga("geecD_templateCartelle",$this->id);
            $this->datiTemplate      = $datiTemplate;
            $this->cartellaCollegata = $datiTemplate["cartellaCollegata"];
            $this->nome              = $datiTemplate["nome"];
            $this->descrizione       = $datiTemplate["descrizione"];
        }
        
        // getter & setter
        
        function getId() {
            return $this->id;
        }
        public function getCartellaCollegata() {
            return $this->cartellaCollegata;
        }

        function getDescrizione() {
            return $this->descrizione;
        }
        
        function getNome() {
            return $this->nome;
        }
        
        function getDataCreazione() {
            return $this->dataCreazione;
        }

        function setId($id) {
            $this->id = $id;
        }

        public function setCartellaCollegata($cartellaCollegata): void {
            $this->cartellaCollegata = $cartellaCollegata;
        }
        
        function setNome($nome) {
            $this->nome = $nome;
        }
        
        function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }
        
        function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }
    }
